<?php
require 'config.php';
require 'helpers.php';

$sell_id = intval($_GET['sell_id'] ?? 0);
$token   = $_GET['token'] ?? '';

if ($sell_id <= 0 || empty($token)) {
    die('Thiếu tham số');
}

/* Kiểm tra đơn + token */
$rs = $mysqli->query("
    SELECT transaction_date
    FROM transactions
    WHERE id = $sell_id
");
$check = $rs->fetch_assoc();

if (!$check) {
    die('Đơn không tồn tại');
}

$valid_token = generate_token(
    $sell_id,
    date('Y-m-d', strtotime($check['transaction_date']))
);

if (!hash_equals($valid_token, $token)) {
    die('Token không hợp lệ');
}

/* Thông tin đơn */
$order = $mysqli->query("
    SELECT t.id, t.transaction_date, c.name AS customer_name
    FROM transactions t
    LEFT JOIN contacts c ON t.contact_id = c.id
    WHERE t.id = $sell_id
")->fetch_assoc();

/* Danh sách sản phẩm */
$items = [];
$rs = $mysqli->query("
    SELECT p.name, sl.quantity
    FROM transaction_sell_lines sl
    LEFT JOIN products p ON sl.product_id = p.id
    WHERE sl.transaction_id = $sell_id
");
while ($row = $rs->fetch_assoc()) {
    $items[] = $row;
}

require __DIR__ . '/templates/default.php';